#ifndef _METER_MCU_H_
#define _METER_MCU_H_

#include "csg_structure.h"
#include <msp430xG46x.h>

extern unsigned int gFlag;
extern unsigned char gStatus;
extern struct csg_phase_parms_s meter1;

#define BAUTRATE_9600
#define USART0_BAUD_RATE 9600

#define FL_AFE_INTERRUPT_IN 0x0001    //AFE event triggerred
#define FL_AFE_READ         0x0010    //one AFE packet read in afe_read_message[]
#define FL_HST_READ_AFE_CAL 0x0100    //host require read AFE calibration data
#define FL_HST_READ_AFE_CONF 0x0200    //host require read AFE configuration data
#define FL_AFE_READING_OUT_EN 0x1000    //AFE event triggerred
#define FL_AFE_READING_OUT_CH 0x2000    //AFE event triggerred


#define ST_AFE_READING 0x01       //one byte is reading from AFE
#define ST_AFE_WRITING 0x02       //one packet is writing to AFE
#define ST_AFE_READING_TOUT 0x04  //CSG reading timeout
#define ST_AFE_INTERVAL_REACHED 0x08  //1ms interval reached after last sent/received bytes

#define TIMEROUT_AFE_READ 32768    //1s
#define INTERVAL_BETWEEN_BYTES 32       //1ms

#define phase                           (&meter1.metrology)
#define phase_nv                        (&meter1.nv_parms)
#define neutral_nv                      (&meter1.nv_parms.current[1])
#define phase_conf                      (&meter1.config)

#endif